#include "acqfile.h"
#include <cmath>
#include <fstream>
using namespace std;

bool ACQFile::loaddata( const string &filename){
	file.clear();
	file.open( filename.c_str(), ios_base::in|ios_base::binary);
	if( file.fail()){ file.close(); return false; }
	lBufLength = 0; lPositionStart = 0;
	dSampleTime=0.0;
	long lVersion=0;
	long lExtItemHeaderLen=0;
	int nChannels=0;
	long lChanHeaderLen=0;
	int nLengthOfForeignData=0;
	int nType=0;
	
	// version check
	file.seekg( 2);	lVersion=0;
	file.read( reinterpret_cast< char *>(&lVersion), 4);
	if( lVersion < 41){ return false; }
	file.seekg( 6); lExtItemHeaderLen=0;
	file.read( reinterpret_cast< char *>(&lExtItemHeaderLen), 4);
	file.seekg( 10); nChannels=0;
	file.read( reinterpret_cast< char *>(&nChannels), 2);
	if( 1 != nChannels) return false;
	file.seekg( 16);dSampleTime=0;
	file.read( reinterpret_cast< char *>(&dSampleTime), 8);
	file.seekg( lExtItemHeaderLen);lChanHeaderLen=0;
	file.read( reinterpret_cast< char *>(&lChanHeaderLen), 4);
	file.seekg( lExtItemHeaderLen + 88);lBufLength=0;
	file.read( reinterpret_cast< char *>(&lBufLength), 4);
	file.seekg( lExtItemHeaderLen + 92);dAmplScale=0;
	file.read( reinterpret_cast< char *>(&dAmplScale), 8);
	file.seekg( lExtItemHeaderLen + 100);dAmplOffset=0;
	file.read( reinterpret_cast< char *>(&dAmplOffset), 8);
	file.seekg( lExtItemHeaderLen + lChanHeaderLen);nLengthOfForeignData=0;
	file.read( reinterpret_cast< char *>(&nLengthOfForeignData), 2);
	file.seekg( lExtItemHeaderLen + lChanHeaderLen + nLengthOfForeignData + 2);nType=0;
	file.read( reinterpret_cast< char *>(&nType), 2);
	if( 2 != nType){ return false;  }
	lPositionStart = lExtItemHeaderLen + lChanHeaderLen + nLengthOfForeignData + 4;
	if( lBufLength<=65536) return false;
	strFileName = filename;

	lCurrentPosition = 0;

	short int *buf = new short int[256];
	nSummaryLen = 2048;
//	rSummary = new double[nSummaryLen];
//	int nSumStep = lBufLength/nSummaryLen;
	nMin = 999999;
	nMax = -999999;
	double sum = 0.;
	double ssum = 0.;
	int n=0;
	int len = lBufLength;
	while( len>0){
		int n2 = ((256<len)?256:len);
		file.read( reinterpret_cast< char *>(buf), n2*2);
		int jcount = file.gcount();
		if( jcount <n2*2){ delete []buf; return false;}	// somewhere fails
		int j;
		for( j=0; j<n2; j++,n++) {
			sum += static_cast<double>(buf[j]);
			ssum += (static_cast<double>(buf[j])*static_cast<double>(buf[j]));
			if( nMin > buf[j]) nMin = buf[j];
			if( nMax < buf[j]) nMax = buf[j];
		}
		len -= 256;
	}
	rMean = sum/static_cast<double>(lBufLength);
	rSD = sqrt((ssum-rMean*rMean)/static_cast<double>(lBufLength-1));
	rMean = rMean*dAmplScale+dAmplOffset;
	rSD = rSD*dAmplScale;
	delete []buf;
#if 0
	ofstream ofs1( "debug.txt", std::ios_base::app);
	ofs1 << "rMean="<<rMean<<"\n";
	ofs1 << "rSD="<<rSD<<"\n";
	ofs1 << "dAmplScale="<< dAmplScale<<"\n";
	ofs1 << "dAmplOffset="<<dAmplOffset<<"\n";
	ofs1.close(); 
#endif

	return true;
}
bool ACQFile::GetArray( double* arr, int len){
	if(lCurrentPosition + len > lBufLength) return false;
	short int *buf = new short int[256];
	file.seekg( lPositionStart + 2*lCurrentPosition);
	lCurrentPosition += len;
	int n=0;
	while( len>0){
		int n2 = ((256<len)?256:len);
		file.read( reinterpret_cast< char *>(buf), n2*2);
		int jcount = file.gcount( );
		if( jcount <n2*2){ delete []buf; return false;}	// somewhere fails
		int j;
		for( j=0; j<n2; j++,n++)
			arr[n] = static_cast<double>(buf[j])*dAmplScale+dAmplOffset;
		len -= 256;
	}
	delete []buf;
	return true;
}
