#ifndef ACQFILE_H
#define ACQFILE_H
#include <string>
#include <fstream>
using namespace std;

class ACQFile{
	public:
		ACQFile():dSampleTime(0),lBufLength(0),dAmplScale(1.),
			dAmplOffset(0.),lPositionStart(0),nMin(0),nMax(1),rMean(0.),rSD(1.),
			rSummary(0){}
		~ACQFile(){ if(file.is_open()) file.close(); if(rSummary) delete []rSummary;}
		double sampleTime()const{ return dSampleTime;}
		long bufLength()const{ return lBufLength;}
		long positionStart()const{ return lPositionStart;}
		const string& FileName()const{ return strFileName;}
		bool loaddata( const string &filename);
		bool Summary(double *&data, int &len)const{
			if( !rSummary) return false; data=rSummary,len=nSummaryLen;return true;}
		int Min()const{return nMin;}
		int Max()const{return nMax;}
		double Scale()const{ return dAmplScale;}
		double Offset()const{ return	dAmplOffset;}
		bool SetPosition( int pos){
			if(0<=pos&&pos<lBufLength){lCurrentPosition=pos;return true;}
			else return false;}
		bool GetArray( double* arr, int len);
		double TimeMax()const{ return(lBufLength*dSampleTime/1000.);}
		double Mean()const{ return rMean;}
		double StandardDeviation()const{ return rSD;}
	private:
		ifstream file;
		double dSampleTime;
		long lBufLength;
		double dAmplScale, dAmplOffset;
		long lPositionStart;
		string strFileName;
		long lCurrentPosition;
		int nMin;
		int nMax;
		double rMean;
		double rSD;
		double *rSummary;
		int nSummaryLen;
};

#endif // ACQFILE_H
