#include <cstdlib>
#include <iostream>
using namespace std;

const int nFrameLength = 65536;
const int numberOfPeaks=8;
#include "fft.h"
#include "acqfile.h"
bool powersetCurrent( 
		double ts,
		ACQFile* acqfile,
		double *&amplitude,
		double *&rSpectrum,
		double *&rTopPeaks,
		int *&pnPeakPos 
		);
bool powersetCurrent( 
		double th, double tm, double ts,
		ACQFile* acqfile,
		double *&amplitude,
		double *&rSpectrum,
		double *&rTopPeaks,
		int *&pnPeakPos 
		){ return powersetCurrent( 
			th*60*60+tm*60+ts,
			acqfile,
			amplitude,
			rSpectrum,
			rTopPeaks,
			pnPeakPos 
			);
}

// return the basename from a path name
string baseName( const string& path){
	string::size_type from, end;
	from = path.find_last_of( "/\\");
	end = path.find_last_of( ".");
	if( from == string::npos) from = 0;
	else from ++;
	if( end == string::npos || end < from) end = path.length();

	return string( path.begin()+from, path.begin()+end);
}
// convert a double value to a 4-digits string( for time only)
//
string d2s( double r){
	int n = static_cast<int>(r);
	string s="0000";
	s[0] = '0'+(n/1000)%10;
	s[1] = '0'+(n/100)%10;
	s[2] = '0'+(n/10)%10;
	s[3] = '0'+(n/1)%10;
	return s;
}
void outputDoubles( const string& filename, double* arr, int len){
	ofstream ofs( filename.c_str(), ios::app|ios::binary);
	int n;
	for( n=0; n<len-1; n++)
		ofs<< showpoint<< fixed<<arr[n] << ",";
	ofs<< showpoint<< fixed<<arr[n]<<endl;
	ofs.close();
}

int main(int argc, char **argv){
	double *amplitude=0;
	double *rSpectrum=0;
	double *rTopPeaks=0;
	int *pnPeakPos=0; 

	const char *acqFileName = "../Untitled10408-EGTA.acq";
	if( argc > 1) acqFileName = argv[1];

	ACQFile* acqfile = new ACQFile;
	if( !acqfile->loaddata( acqFileName)){
		cerr<< "error load ACQ file." << endl;
		return -1;
	}

	double rBegin, rEnd, rStep;
	rBegin = rEnd = 0.;
	rStep = 1.;
	if( argc > 2) {
		rBegin = atof( argv[2]);
		rEnd = rBegin;
		if( argc > 3){
			rEnd = atof( argv[3]);
			if( argc > 4){
				rStep = atof( argv[4]);
			}
		}
	}
	// validate time values
	if( rBegin<0. || rEnd < rBegin || rStep < .99 || rBegin > acqfile->TimeMax()){
		cerr << "Error time specefied." << endl;
		return -2;
	}
	if( rEnd > acqfile->TimeMax()){
		rEnd = acqfile->TimeMax();
		cout << "End of time modified to " << rEnd << endl;
	}

	string basefilename = baseName( acqFileName);
	cout << "Output of spectrum in file(s) " << basefilename << ".spectrum.csv" << endl;
	cout << "peaks in file " << basefilename << ".peaks.csv" << endl;
	cout << "time from "<<rBegin << " to " << rEnd << " with step " << rStep 
		<< " ( in seconds) will be calculated." << endl;
	cout << endl;
	cout << endl;
	ofstream ofsSpectrum( (basefilename+".spectrum.csv").c_str(), ios::binary);
	ofstream ofsPeak( (basefilename+".peak.csv").c_str(), ios::binary);

	double dt;
	for( dt=rBegin; dt<=rEnd; dt+=rStep){
//		string strOutputFileName = basefilename + "." + d2s( dt) + ".csv";
//		cout << strOutputFileName << endl;
		if( powersetCurrent( 
					dt, 
					acqfile,
					amplitude,
					rSpectrum,
					rTopPeaks,
					pnPeakPos 
					) ){
			//		outputDoubles( strOutputFileName, rSpectrum, nFrameLength);
			int n;
			ofsSpectrum << dt;
			for( n=0; n<nFrameLength/16; n++)
				ofsSpectrum<< ", " << showpoint<< fixed<<rSpectrum[n];
			ofsSpectrum << endl;
			ofsPeak<< dt;
			for( n=0; n<numberOfPeaks; n++)
				ofsPeak<< ", " << pnPeakPos[n] << ", " << showpoint<< fixed<<rTopPeaks[n];
			ofsPeak<< endl;
		}else{
			cout << "Fail at " << dt << endl;
		}
		cout << ".";
		cout.flush();
	}

	if(ofsSpectrum.is_open()) ofsSpectrum.close(); 
	if(ofsPeak.is_open()) ofsPeak.close(); 
	if( amplitude){ delete []amplitude; amplitude=0;}
	if( rSpectrum){ delete [] rSpectrum; rSpectrum=0;}
	if( rTopPeaks){ delete [] rTopPeaks; rTopPeaks=0;}
	if( pnPeakPos){ delete [] pnPeakPos; pnPeakPos=0;}
	DeinitFFT();

	return 0;
}


bool powersetCurrent( 
		double ts,
		ACQFile* acqfile,
		double *&amplitude,
		double *&rSpectrum,
		double *&rTopPeaks,
		int *&pnPeakPos 
		) {
	if( amplitude){ delete []amplitude; amplitude=0;}
	if( rSpectrum){ delete [] rSpectrum; rSpectrum=0;}
	if( rTopPeaks){ delete [] rTopPeaks; rTopPeaks=0;}
	if( pnPeakPos){ delete [] pnPeakPos; pnPeakPos=0;}

	double rCurrentFrameStart;
	rCurrentFrameStart = static_cast<double>( ts);

	amplitude = new double[nFrameLength];
	rSpectrum = new double[nFrameLength];

	if( acqfile){
		if(!acqfile->SetPosition(
					static_cast<long>(rCurrentFrameStart/ acqfile->sampleTime()*1000)))
			return false;
		if( !acqfile->GetArray( amplitude, nFrameLength)) return false;

		// fft and such
		int nLenOfSpectrum = nFrameLength/8;
		int nNumOfPeaks = numberOfPeaks;
		rTopPeaks = new double[nNumOfPeaks];
		pnPeakPos = new int[nNumOfPeaks];
		genPower( amplitude, nFrameLength,
				rSpectrum, nLenOfSpectrum, rTopPeaks, pnPeakPos, nNumOfPeaks);
		//		QString strPeaks = tr("peaks:");
		//		for( i=0; i<nNumOfPeaks; i++)
		//			strPeaks += QString( "[%1,%2]").arg(pnPeakPos[i]).arg(rTopPeaks[i],4,'f');
		//		dynamic_cast<MainWindow*>(parentWidget())->
		//			statusBar()->showMessage( strPeaks);
		//		delete []rTopPeaks;
		//		delete []pnPeakPos;
		//		cout << amplitude<< rSpectrum<< nFrameLength <<endl;
	}
	return true;
}
